package cn.com.duiba.tuia.media.api.constant;

/**
 * 活动状态常量类
 *
 * @author xuyenan
 * @createTime 2016/10/31
 */
public class ActivityStatusConstant {

    /**
     * 开启且可见
     */
    public static final int        STATUS_OPEN       = 1;
    /**
     * 关闭且可见
     */
    public static final int        STATUS_CLOSE_SHOW = 2;
    /**
     * 关闭不可见
     */
    public static final int        STATUS_CLOSE      = 3;
    /**
     * 数据不完整
     */
    public static final int        STATUS_INIT       = 0;

    private ActivityStatusConstant asc;

    public ActivityStatusConstant getActivityStatusConstant() {
        if (asc == null) {
            asc = new ActivityStatusConstant();
        }
        return asc;
    }

    /**
     * 获取状态文案
     * 
     * @param status 状态编码
     * @return 状态文案
     */
    public static String getStatusText(Integer status) {
        String text = "状态未定义";
        if (status != null) {
            switch (status) {
                case STATUS_INIT:
                    text = "数据不完整";
                    break;

                case STATUS_OPEN:
                    text = "开启且可见";
                    break;

                case STATUS_CLOSE_SHOW:
                    text = "关闭且可见";
                    break;

                case STATUS_CLOSE:
                    text = " 关闭不可见";
                    break;
                default:
                    break;
            }
        }
        return text;
    }

}
