/**
 * Project Name:media-api<br>
 * File Name:RemoteSlotService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年9月30日下午4:21:08<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotBackendDetailDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteSlotService <br/>
 * Function: 广告位. <br/>
 * date: 2016年9月30日 下午4:21:08 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface RemoteSlotBackendService {

    /**
     * 查询广告位详情.
     *
     * @param slotId 广告位id
     * @return 广告位详情
     */
    DubboResult<RspSlotBackendDetailDto> getDetail(long slotId);

    /**
     * 查询广告位集合.
     *
     * @param slotIds the slot ids
     * @return the detail
     */
    DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds);

    /**
     * 分页查询广告位数据.
     *
     * @param req the req
     * @return the slots by page
     */
    DubboResult<PageResultDto<RspAdsenseSlotListDto>> getSlotsByPage(ReqGetSlotsByPageDto req);

    /**
     * 批量更新广告位审核状态.
     *
     * @param slotIds 广告位ID列表
     * @param status 审核操作(0:待审核，1:审核拒绝， 2：审核通过)
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> batchUpdateCheckStatus(List<Long> slotIds, int status);

    /**
     * 更新广告位.
     *
     * @param param the param
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> update(ReqUpdateSlotStrategy param);

    /**
     * 查看广告选择类型参数
     * 
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<SlotTypeParamDto>> selectSlotTypeParam();

    /**
     * 修改广告部分属性
     * 
     * @param slotDto
     * @return boolean
     */
    DubboResult<Boolean> updateSlot(SlotDto slotDto);

    /**
     * 通过广告位名称查询广告id集合
     * 
     * @param slotName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getSlotIdsByName(String slotName);

    /**
     * 获取缓存中的所有的广告id和名称
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> getAllSlotIdAndNameCache();

    /**
     * 删除缓存中的所有的广告id和名称
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> delAllSlotIdAndNameCache();
    
    /**
     * 
     * getSlotById:(通过广告Id查询广告). <br/>
     *
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<SlotDto> getSlotById(Long slotId);
}
