package cn.com.duiba.tuia.media.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author zfz
 * @createTime 2016/10/25
 */
public interface RemoteAccountChangeBackendService {

    /**
     * addAccountChange:(增加媒体月流水记录). <br/>
     *
     * @author ZFZ
     * @param accountChangeDto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addAccountChange(AccountChangeDto accountChangeDto);

    /**
     * selectAccountChangeList:(分页查询媒体账户月资金流水记录). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<RspAccountChangeResult<AccountChangeRsp>> selectAccountChangeByPage(ReqAccountChange req);

    /**
     * 
     * selectAccountChangeById:(通过结算Id查找). <br/>
     *
     * @author ZFZ
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountChangeDto> selectAccountChangeById(Long id);
    
    /**
     * 
     * selectAccountChangeByMediaId:(通过媒体用户id查找最后一条资金记录). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountChangeDto> selectAccountChangeByMediaId(Long mediaId);
    
    /**
     * 
     * exportAccountChangeList:(查询媒体账户月资金记录). <br/>
     *
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountChangeDto>> selectAccountChangeList(ReqAccountChange req); 
}
