/**
 * Project Name:media-biz<br>
 * File Name:CacheKeyUtils.java<br>
 * Package Name:cn.com.duiba.tuia.media.utils<br>
 * Date:2016年9月26日下午4:59:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.utils;

import cn.com.duiba.tuia.media.api.constant.CacheKey;
import cn.com.duiba.tuia.media.api.constant.SplitConstant;

/**
 * ClassName: CacheKeyUtils <br/>
 * Function: 获取缓存标志. <br/>
 * date: 2016年9月26日 下午4:59:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class CacheKeyUtils {

    /** The prefix. */
    private static String prefix;

    private CacheKeyUtils cu;

    public CacheKeyUtils getCacheKeyUtils() {
        if (cu == null) {
            cu = new CacheKeyUtils();
        }
        return cu;
    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CacheKeyUtils.prefix = prefix;
    }

    /**
     * 获取短信缓存标志.
     *
     * @param phone 手机号
     * @param type 类型
     * @return the sms key
     */
    public static String getSmsKey(String phone, int type) {
        return getPrefix() + CacheKey.SMS_KEY + phone + "-" + type;
    }

    /**
     * 获取邮件验证码标识.
     *
     * @param userEmail 邮箱
     * @return the email key
     */
    public static String getResetPwEmailKey(String userEmail) {
        return getPrefix() + CacheKey.RESETPD_EMAIL_KEY + userEmail;
    }

    /**
     * 获取更好邮箱的邮件验证码标识.
     *
     * @param userId the user id
     * @param token the token
     * @return the email key
     */
    public static String getReplaceEmailKey(Long userId, String token) {
        return getPrefix() + CacheKey.REPLACE_EMAIL_KEY + userId + '-' + token;
    }

    /**
     * 获取屏蔽策略缓存标识.
     *
     * @param strategyId 屏蔽策略ID
     * @return the strategy key
     */
    public static String getStrategyKey(long strategyId) {
        return getPrefix() + CacheKey.STRATEGY_KEY + strategyId;
    }

    /**
     * 获取媒体用户状态缓存标识.
     *
     * @param mediaId 媒体ID
     * @return the media status key
     */
    public static String getMediaStatusKey(long mediaId) {
        return getPrefix() + CacheKey.MEDIA_STATUS_KEY + mediaId;
    }

    /**
     * 获取媒体缓存标识.
     *
     * @param slotId the slot id
     * @return the media app strategy key
     */
    public static String getSlotKey(long slotId) {
        return getPrefix() + CacheKey.SLOT_KEY + slotId;
    }

    /**
     * 获取媒体缓存标识.
     *
     * @param mediaAppId 媒体ID
     * @return the media app key
     */
    public static String getMediaAppKey(long mediaAppId) {
        return getPrefix() + CacheKey.MEDIA_APP_KEY + mediaAppId;
    }

    /**
     * 获取媒体缓存标识.
     *
     * @param appKey app key
     * @return the media app key
     */
    public static String getMediaAppByKey(String appKey) {
        return getPrefix() + CacheKey.MEDIA_APP_BY_KEY + appKey;
    }

    /**
     * 媒体应用的ID和名称集合标识.
     *
     * @param appId the app id
     * @return the app id and name key
     */
    public static String getAppIdAndNameKey(long appId) {
        return getPrefix() + CacheKey.APPID_AND_NAME_KEY + appId;
    }

    /**
     * 广告位ID和广告位名称集合标示 <br/>
     *
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    public static String getSlotIdAndNameKey(long slotId) {
        return getPrefix() + CacheKey.SOLTID_AND_NAME_KEY + slotId;
    }

    /**
     * 活动类型和活动类型中文KEY <br/>
     *
     * @param actType
     * @return
     * @since JDK 1.6
     */
    public static String getActTypeAndNameKey(String actType) {
        return getPrefix() + CacheKey.ACT_AND_NAME_KEY + actType;
    }

    /**
     * 获取所有活动类型和活动类型中文KEY <br/>
     *
     * @return
     * @since JDK 1.6
     */
    public static String getAllActTypeAndNameKey() {
        return getPrefix() + CacheKey.ALL_ACT_AND_NAME_KEY;
    }

    /**
     * 获取活动缓存标识.
     *
     * @param activityKey activity key
     * @return the activity key
     */
    public static String getActivityByKey(String activityKey) {
        return getPrefix() + CacheKey.ACTIVITY_KEY + activityKey;
    }

    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param activityType
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKey(Long activityId, Integer activityType) {
        return getPrefix() + CacheKey.ACTIVITY_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }

    /**
     * getMediaAccountByKey:(通过key查询缓存中的媒体用户信息). <br/>
     *
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    public static String getMediaAccountByKey(Long mediaId) {
        return getPrefix() + CacheKey.MEDIA_ACOUNT_KEY + mediaId;
    }
}
