/**
 * Project Name:media-biz<br>
 * File Name:MediaAppData.java<br>
 * Package Name:cn.com.duiba.tuia.media.model<br>
 * Date:2016年9月29日下午5:13:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: MediaAppData <br/>
 * Function: 媒体缓存数据. <br/>
 * date: 2016年9月29日 下午5:13:36 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class MediaAppDataDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The app id. */
    private long              appId;

    /** 媒体ID. */
    private long              mediaId;

    /** The app key. */
    private String            appKey;

    /** The app secret. */
    private String            appSecret;

    /** 是否有效(true：有效， false：无效). */
    private boolean           isValid;

    /** 行业. */
    private String            industry;

    /** 平台类型 */
    private String            platform;

    /**
     * Creates a new instance of MediaAppDataDto.
     *
     * @param mediaId
     * @param appKey
     * @param appSecret
     * @param industry
     */
    public MediaAppDataDto(long mediaId, String appKey, String appSecret, String industry) {
        super();
        this.mediaId = mediaId;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.industry = industry;
    }

    /**
     * Creates a new instance of MediaAppDataDto.
     *
     * @param appId
     */
    public MediaAppDataDto(long appId) {
        super();
        this.appId = appId;
    }

    /**
     * The Constructor.
     */
    public MediaAppDataDto() {
        super();
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
