/**
 * Project Name:tuia-core-api<br>
 * File Name:TagDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:18:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: TagDto <br/>
 * Function: 标签层级关系. <br/>
 * date: 2016年9月27日 下午7:18:45 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class TagLevel implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 标签(分类)编码. */
    private String            key;

    /** 标签(分类)名称. */
    private String            text;

    /**
     * 
     * Creates a new instance of TagLevel.
     *
     */
    public TagLevel() {
        super();
    }

    /**
     * 
     * Creates a new instance of TagLevel.
     *
     * @param key
     * @param text
     */
    public TagLevel(String key, String text) {
        super();
        this.key = key;
        this.text = text;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
