/**
 * Project Name:media-api File Name:ReqMediaAppStatusDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月19日下午8:31:13 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMediaAppStatusDto <br/>
 * Function: 修改媒体app状态Dto. <br/>
 * Date: 2016年10月19日 下午8:31:13 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqUpdateMediaAppStatusDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID     = -7823268451467834867L;

    /** 修改成功标识 */
    public static final int   UPDATE_SUCCESS       = 1;

    /** 开通状态:0-待审核. */
    public static final int   MEDIA_APP_CHECKING   = 0;
    /** 开通状态:1-审核通过. */
    public static final int   MEDIA_APP_CHECK_PASS = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int   MEDIA_APP_CHECK_FAIL = 2;

    /** 媒体Id */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long              appId;

    /** 媒体审核状态 */
    @ApiModelProperty(value = "媒体审核状态", required = true)
    @NotNull(message = "媒体审核状态不能为空")
    private Integer           checkStatus;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
