/**
 * Project Name:media-api File Name:ReqCopySlot.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2017年2月21日下午3:22:42 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqCopySlot <br/>
 * Function: 拷贝广告位信息. <br/>
 * Date: 2017年2月21日 下午3:22:42 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqCopySlot implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 4683710267820313089L;

    /** 需要被拷贝的广告位ID */
    @ApiModelProperty(value = "被拷贝的广告位Id", required = true)
    @NotNull(message = "被拷贝的广告位Id")
    private Long              parentSlotId;

    /** 需要拷贝的广告位ID */
    @ApiModelProperty(value = "需要拷贝的广告位ID", required = true)
    @NotNull(message = "需要拷贝的广告位ID")
    private Long              childSlotId;

    public Long getParentSlotId() {
        return parentSlotId;
    }

    public void setParentSlotId(Long parentSlotId) {
        this.parentSlotId = parentSlotId;
    }

    public Long getChildSlotId() {
        return childSlotId;
    }

    public void setChildSlotId(Long childSlotId) {
        this.childSlotId = childSlotId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
