/**
 * Project Name:media-api File Name:ReqDataStatisticsByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月11日下午3:09:44 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import cn.com.duiba.tuia.media.api.dto.BaseQueryDto;

/**
 * ClassName:ReqDataStatisticsByPageDto <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月11日 下午3:09:44 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqSlotLineStatisticsByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = -5308774071126171980L;

    /** 以当前时间进行排序 */
    public static final String SORT_TYPE        = "cur_date";

    /** 升序排序 */
    public static final String ORDER_TYPE       = "asc";

    /** 开始时间 */
    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private Date               startDate;

    /** 结束时间 */
    @ApiModelProperty(value = "结束时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private Date               endDate;

    /** 媒体用户ID */
    @ApiModelProperty(value = "媒体用户ID", required = false)
    private Long               mediaId;
    
	/** 广告位id列表 */
	private List<Long>         slotIds;
	
	/** app_id列表 */
	private List<Long>         appIds;
	
	/**广告类型*/
	private Integer            slotType;


    public List<Long> getAppIds() {
		return appIds;
	}

	public void setAppIds(List<Long> appIds) {
		this.appIds = appIds;
	}

	public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }
    

    public List<Long> getSlotIds() {
  		return slotIds;
  	}

  	public void setSlotIds(List<Long> slotIds) {
  		this.slotIds = slotIds;
  	}
  	
  	 public Integer getSlotType() {
         return slotType;
     }
     
     public void setSlotType(Integer slotType) {
         this.slotType = slotType;
     }
     
     @Override
     public String toString() {
         return ToStringBuilder.reflectionToString(this);
     }
}
