package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

/**
 * Function: RspActivityDto
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public class RspActivityDto implements Serializable {

    private static final long                 serialVersionUID = 98764557625344564L;

    /** 活动开启状态 */
    public static final int                   ACT_ENABLE       = 1;

    /** 活动关闭状态 */
    public static final int                   ACT_UNABLE       = 0;

    /** 活动已经定向给指定媒体 */
    public static final boolean               ACT_BINDED       = true;

    /** 活动未定向给指定媒体 */
    public static final boolean               ACT_UNBIND       = false;

    /** 开启定向媒体 */
    public static final int                   IS_DIRECTMEDIA   = 1;
    
    /** 关闭定向媒体 */
    public static final int                   NO_DIRECTMEDIA   = 0;

    /** 活动ID */
    private Long                              id;

    /** 活动名称 */
    private String                            name;

    /** 活动类型 */
    private Integer                           type;

    /** 活动类型名称 */
    private String                            typeName;

    /** 兑吧活动状态 */
    private Integer                           activityStatus;

    /** 活动状态 */
    private String                            status;

    /** 广告位素材规格列表 */
    private List<Long>                        msIdList;

    /** 定向模式： 0仅投放定向列表，1优先投放定向列表 */
    private Integer                           directAdvertMode;

    /** 是否定向广告券 */
    private Integer                           isDirectAdvert;

    /** 是否定向媒体 */
    private Integer                           isDirectMedia;

    /** 活动是否开启 */
    private Integer                           isEnable;

    /** 是否已发布活动计划 */
    private Integer                           isPublish;

    /** 规格内容列表 */
    private List<RspMaterialSpecificationDto> msList;

    /** 活动计划ID */
    private Long                              planId;

    /** 素材数量 */
    private Integer                           itemContentAmount;

    /** 该活动是否已经定向媒体 */
    private Boolean                           isBinded;

    /** 活动来源 0-兑吧活动 1-推啊活动 */
    private Integer                           source;
    
    /** 排序位置 */
    private Integer                           index;
    
    /** 活动连接 */
    private String                            activityUrl;

    public String getActivityUrl() {
		return activityUrl;
	}

	public void setActivityUrl(String activityUrl) {
		this.activityUrl = activityUrl;
	}

	/**
     * source.
     *
     * @return the source
     * @since JDK 1.6
     */
    public Integer getSource() {
        return source;
    }

    /**
     * source.
     *
     * @param source the source to set
     * @since JDK 1.6
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * isBinded.
     *
     * @return the isBinded
     * @since JDK 1.6
     */
    public Boolean getIsBinded() {
        return isBinded;
    }

    /**
     * isBinded.
     *
     * @param isBinded the isBinded to set
     * @since JDK 1.6
     */
    public void setIsBinded(Boolean isBinded) {
        this.isBinded = isBinded;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Long> getMsIdList() {
        return msIdList;
    }

    public void setMsIdList(List<Long> msIdList) {
        this.msIdList = msIdList;
    }

    public Integer getDirectAdvertMode() {
        return directAdvertMode;
    }

    public void setDirectAdvertMode(Integer directAdvertMode) {
        this.directAdvertMode = directAdvertMode;
    }

    public Integer getIsDirectAdvert() {
        return isDirectAdvert;
    }

    public void setIsDirectAdvert(Integer isDirectAdvert) {
        this.isDirectAdvert = isDirectAdvert;
    }

    public Integer getIsDirectMedia() {
        return isDirectMedia;
    }

    public void setIsDirectMedia(Integer isDirectMedia) {
        this.isDirectMedia = isDirectMedia;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public List<RspMaterialSpecificationDto> getMsList() {
        return msList;
    }

    public void setMsList(List<RspMaterialSpecificationDto> msList) {
        this.msList = msList;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Integer getItemContentAmount() {
        return itemContentAmount;
    }

    public void setItemContentAmount(Integer itemContentAmount) {
        this.itemContentAmount = itemContentAmount;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }
}
