/**
 * Project Name:media-api File Name:RspAppInnerLogDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2017年2月16日下午2:54:25 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspAppInnerLogDto <br/>
 * Function: 媒体信息内部日志. <br/>
 * Date: 2017年2月16日 下午2:54:25 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspAppInnerLogDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -8969287935042092747L;

    /** 媒体ID */
    private Long              mediaId;
    /** 应用ID */
    private Long              appId;
    /** 应用名称 */
    private String            appName;
    /** 审核状态 */
    private Integer           checkStatus;
    /** 系统平台 */
    private String            platform;
    /** 计费方式 */
    private Integer           chargeType;
    /** 价格 */
    private Long              price;
    /** 媒体分账比例 */
    private Double            mediaSplitRatio;
    /** 平台分账比例 */
    private Double            platformSplitRatio;
    /** 新增或修改时间 */
    private String            time;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Double getMediaSplitRatio() {
        return mediaSplitRatio;
    }

    public void setMediaSplitRatio(Double mediaSplitRatio) {
        this.mediaSplitRatio = mediaSplitRatio;
    }

    public Double getPlatformSplitRatio() {
        return platformSplitRatio;
    }

    public void setPlatformSplitRatio(Double platformSplitRatio) {
        this.platformSplitRatio = platformSplitRatio;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
