/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteSlotBackendService;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteSlotBackendServiceImpl
extends BaseRemoteService
implements RemoteSlotBackendService {
    @Autowired
    private SlotService slotService;
    @Autowired
    private SlotBackendBo slotBackendBo;

    public DubboResult<RspSlotDetailDto> getDetail(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.getBackendSlotDetailById(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getDetail is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<PageResultDto<RspAdsenseSlotListDto>> getSlotsByPage(ReqGetSlotsByPageDto req) {
        try {
            return DubboResult.successResult(this.slotService.selectAdsenseListByPage(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getSlotsByPage is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> batchUpdateCheckStatus(List<Long> slotIds, int status) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.batchUpdateCheckStatus(slotIds, status));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.batchUpdateCheckStatus is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds) {
        try {
            return DubboResult.successResult(this.slotService.getListDetail(slotIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.getListDetail is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> update(ReqUpdateSlotStrategy param) {
        try {
            return DubboResult.successResult((Object)this.slotBackendBo.updateSlotStrategy(param));
        }
        catch (Exception e) {
            this.logger.error("RemoteSlotBackendService.update is error");
            return this.exceptionFailure(e);
        }
    }
}

