/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.service.impl.BaseCacheService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaCacheService
extends BaseCacheService {
    @Autowired
    MediaAppDao mediaAppDao;
    @Autowired
    private AccountDAO accountDAO;

    public void updateMediaCache(final long mediaId, final boolean isValid) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                MediaCacheService.this.redisClient.setex(CacheKeyUtils.getMediaStatusKey(mediaId), 604800, JSONObject.toJSONString((Object)isValid));
            }
        });
    }

    public void updateMediaAppCache(final long mediaAppId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MediaCacheService.this.doGetMediaApp(mediaAppId);
                }
                catch (Exception e) {
                    MediaCacheService.this.logger.error("updateMediaAppCache error", (Throwable)e);
                }
            }
        });
    }

    public MediaAppDataDto getMediaApp(long mediaAppId) throws TuiaMediaException {
        String strMedaiAppData = this.redisClient.get(CacheKeyUtils.getMediaAppKey(mediaAppId));
        MediaAppDataDto cacheData = null;
        cacheData = StringUtils.isEmpty((String)strMedaiAppData) ? this.doGetMediaApp(mediaAppId) : (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
        if (cacheData == null) {
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        return cacheData;
    }

    public MediaAppDataDto getMediaAppByKey(String appKey) throws TuiaMediaException {
        String strMedaiAppData = this.redisClient.get(CacheKeyUtils.getMediaAppByKey(appKey));
        MediaAppDataDto cacheData = null;
        cacheData = StringUtils.isEmpty((String)strMedaiAppData) ? this.doGetMediaAppByKey(appKey) : (MediaAppDataDto)JSONObject.parseObject((String)strMedaiAppData, MediaAppDataDto.class);
        if (cacheData == null) {
            throw new TuiaMediaException(ErrorCode.E0401001);
        }
        return cacheData;
    }

    private MediaAppDataDto doGetMediaApp(long mediaAppId) throws TuiaMediaException {
        MediaAppDataDto cacheData = null;
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(mediaAppId);
        if (mediaAppDto != null) {
            cacheData = this.buildMediaAppDataDto(mediaAppDto);
            this.redisClient.setex(CacheKeyUtils.getMediaAppKey(mediaAppId), 604800, JSONObject.toJSONString((Object)cacheData));
            this.redisClient.setex(CacheKeyUtils.getMediaAppByKey(mediaAppDto.getAppKey()), 604800, JSONObject.toJSONString((Object)cacheData));
        }
        return cacheData;
    }

    private MediaAppDataDto doGetMediaAppByKey(String appkey) throws TuiaMediaException {
        MediaAppDataDto cacheData = null;
        MediaAppDto mediaAppDto = this.mediaAppDao.selectByAppKey(appkey);
        if (mediaAppDto != null) {
            cacheData = this.buildMediaAppDataDto(mediaAppDto);
            this.redisClient.setex(CacheKeyUtils.getMediaAppByKey(appkey), 604800, JSONObject.toJSONString((Object)cacheData));
        }
        return cacheData;
    }

    private MediaAppDataDto buildMediaAppDataDto(MediaAppDto mediaAppDto) {
        MediaAppDataDto cacheData = new MediaAppDataDto(mediaAppDto.getMediaId().longValue(), mediaAppDto.getAppKey(), mediaAppDto.getAppSecret(), mediaAppDto.getIndustry());
        cacheData.setValid(1 == mediaAppDto.getCheckStatus());
        cacheData.setAppId(mediaAppDto.getAppId().longValue());
        return cacheData;
    }

    public Boolean isValidMediaApp(long mediaAppId) throws TuiaMediaException {
        MediaAppDataDto cacheData = this.getMediaApp(mediaAppId);
        if (cacheData != null && cacheData.isValid() && this.doGetMediaValid(cacheData.getMediaId()).booleanValue()) {
            return true;
        }
        return false;
    }

    private Boolean doGetMediaValid(long mediaId) throws TuiaMediaException {
        String mediaValid = this.redisClient.get(CacheKeyUtils.getMediaStatusKey(mediaId));
        boolean isValid = false;
        if (mediaValid == null) {
            AccountDto accountDto = this.accountDAO.selectById(mediaId);
            if (accountDto == null) {
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            if (1 == accountDto.getCheckStatus() && 1 == accountDto.getEmailStatus() && 0 == accountDto.getFreezeStatus()) {
                isValid = true;
            }
            this.redisClient.setex(CacheKeyUtils.getMediaStatusKey(mediaId), 604800, JSONObject.toJSONString((Object)isValid));
        }
        return isValid;
    }
}

