/**
 * Project Name:media-biz<br>
 * File Name:StatisticsBackendBO.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo<br>
 * Date:2016年10月10日下午4:23:33<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.bo;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotStatisticsDto;

/**
 * ClassName: StatisticsBackendBO <br/>
 * date: 2016年10月10日 下午4:23:33 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsBackendBO {

    /**
     * 统计广告位数据.
     *
     * @param req the req
     * @return the adsense data
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspSlotStatisticsDto> getAdsenseData(ReqSlotStatisticsDto req) throws TuiaMediaException;

    /**
     * 统计媒体应用数据.
     *
     * @param req the req
     * @return the media data
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspMediaAppStatisticsDto> getMediaData(ReqMediaAppStatisticsDto req) throws TuiaMediaException;
}
