/**
 * Project Name:media-biz<br>
 * File Name:SlotBoImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo.impl<br>
 * Date:2016年10月8日下午5:38:15<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.bo.impl;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.StrategyService;

/**
 * ClassName: SlotBoImpl <br/>
 * date: 2016年10月8日 下午5:38:15 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service
public class SlotBackendBOImpl implements SlotBackendBo {

    /** The logger. */
    protected Logger        logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private SlotService     soltService;

    @Autowired
    private StrategyService strategyService;

    @Autowired
    private MediaAppService mediaAppService;

    @Override
    public Boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {

        // 广告位已经审核过
        List<SlotDto> slotDtoList = soltService.getListDetail(slotIds);
        if (CollectionUtils.isNotEmpty(slotDtoList)) {
            for (SlotDto slotDto : slotDtoList) {
                if (SlotDto.CHECK_STATUS_PASS == slotDto.getCheckStatus()
                    || SlotDto.CHECK_STATUS_FAIL == slotDto.getCheckStatus()) {
                    logger.error("the slot is checked id = [{}]", slotDto.getId());
                    throw new TuiaMediaException(ErrorCode.E0304007);
                }
            }
        }

        // 修改媒体账户审核状态
        return soltService.batchUpdateCheckStatus(slotIds, checkType);
    }

    @Override
    public RspSlotDetailDto getSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = soltService.selectById(slotId);
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setElementType(getTargetList(sltoDto.getElementType()));
        if(sltoDto.getSlotType()==SlotDto.ADSENSE_TYPE_INFORMATION_STREAM){
            rspSlotDetailDto.setPictureSize(sltoDto.getPictureSize());
        }
         // 获取appName
        MediaAppDto mediaAppDto = mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        // 获取屏蔽策略
        RspShieldStrategy rspShieldStrategy = strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }

        return rspSlotDetailDto;
    }
    
    @Override
    public RspSlotDetailDto getBackendSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = soltService.selectById(slotId);
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setElementType(getTargetList(sltoDto.getElementType()));
        if(sltoDto.getSlotType()==SlotDto.ADSENSE_TYPE_INFORMATION_STREAM){
            rspSlotDetailDto.setPictureSize(sltoDto.getPictureSize());
        }else if (SlotDto.ADSENSE_TYPE_PLAQUE == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(SlotPictureSizeEnmu.SIZE_41.getSizeId());
        } else if (SlotDto.ADSENSE_TYPE_STREAMER_BANNER == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(SlotPictureSizeEnmu.SIZE_61.getSizeId());
        } else if (SlotDto.ADSENSE_TYPE_BANNER == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(SlotPictureSizeEnmu.SIZE_81.getSizeId());
        } else if (SlotDto.ADSENSE_TYPE_BUOY == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(SlotPictureSizeEnmu.SIZE_21.getSizeId());
        } else if (SlotDto.ADSENSE_TYPE_APP_WALL == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(SlotPictureSizeEnmu.SIZE_21.getSizeId());
        } else {
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "广告位类型未知");
        }
         // 获取appName
        MediaAppDto mediaAppDto = mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        // 获取屏蔽策略
        RspShieldStrategy rspShieldStrategy = strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }

        return rspSlotDetailDto;
    }

    @SuppressWarnings("unchecked")
    private List<String> getTargetList(String source) {
        // 如果source为空，返回空list
        if (StringUtils.isBlank(source)) {
            return ListUtils.EMPTY_LIST;
        }
        return Arrays.asList(source.split(","));
    }

    @Override
    public Boolean updateSlotStrategy(ReqUpdateSlotStrategy param) throws TuiaMediaException {
        RspShieldStrategy rspShieldStrategy = strategyService.getDetail(param.getStrategyId());
        ReqShieldListStrategy req = new ReqShieldListStrategy();
        if (rspShieldStrategy != null) {
            req.setShieldIndustries(param.getShieldIndustries());
            req.setShieldAdvertisers(param.getShieldAdvertisers());
            req.setId(param.getStrategyId());
        }
        strategyService.updateSlotStrategy(req);
        return true;
    }

}
