/**
 * Project Name:media-biz<br>
 * File Name:AccountBankDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年9月27日下午2:15:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;

/**
 * ClassName: AccountBankDAO <br/>
 * date: 2016年9月27日 下午2:15:36 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountBankDAO {

    /**
     * 通过媒体用户ID查询媒体银行账户信息.
     *
     * @param id the id
     * @return the account bank dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountBankDto selectById(Long media) throws TuiaMediaException;

    /**
     * 更新媒体银行账户信息.
     *
     * @param accountBankDto the account bank dto
     * @throws TuiaMediaException the tuia media exception
     */
    int update(ReqUpdateAccountBank req) throws TuiaMediaException;

    /**
     * 插入媒体银行账户信息.
     *
     * @param accountBankDto the account bank dto
     * @throws TuiaMediaException the tuia media exception
     */
    int insert(AccountBankDto accountBankDto) throws TuiaMediaException;
}
