/**
 * 文件名： AccountCheckRecordDao.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月7日 下午3:11:39
 */
package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;

/**
 * 账号审核记录操作dao<br/>
 *
 * @author: leiliang
 * @创建时间: 2016年4月7日 下午3:11:39
 * @version:
 */
public interface AccountCheckRecordDAO {

    /**
     * 添加账户审核记录.
     *
     * @param dto the dto
     * @return the int
     * @throws TuiaMediaException the media manager exception
     */
    int insertCheckRecord(AccountCheckRecordDto dto) throws TuiaMediaException;

    /**
     * 得到最新的审核记录.
     *
     * @param accountId 用户ID
     * @param checkType 审核类型
     * @return the account 审核记录
     * @throws TuiaCoreException the tuia core exception
     */
    AccountCheckRecordDto selectLatelyCheckRecord(long mediaId, int checkType) throws TuiaMediaException;
}
