package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;

import java.util.List;

/**
 * Function: ActivityAppDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityAppDAO {

    /** 新增 */
    int insertBatch(List<ActivityAppDto> activityAppDtoList) throws TuiaMediaException;

    /** 更新 */
    int update(ActivityAppDto activityAppDto) throws TuiaMediaException;

    /** 根据条件查询 */
    List<ActivityAppDto> selectByCondition(ReqActivityApp reqActivityApp) throws TuiaMediaException;

    /** 根据条件查询时的总数 */
    int selectByConditionAmount(ReqActivityApp reqActivityApp) throws TuiaMediaException;

    /** 移除活动媒体 */
    int delete(Long activityAppId) throws TuiaMediaException;

    /** 批量查询活动媒体 */
    List<ActivityAppDto> selectByActivityAppIds(List<Long> ids) throws TuiaMediaException;
}
