package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;

import java.util.List;

/**
 * Function: ActivityDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityDAO {

    /** 新增 */
    int insertBatch(List<ActivityDto> activityDtoList) throws TuiaMediaException;

    /** 更新 */
    int update(ActivityDto activityDto) throws TuiaMediaException;

    /** 根据条件查询 */
    List<ActivityDto> selectByActivityIds(List<Long> activityIds) throws TuiaMediaException;

    /** 根据与名称和活动类型查询 */
    List<Long> selectByTypeAndName(String name, Integer type) throws TuiaMediaException;

    /** 查询唯一活动记录 */
    ActivityDto selectByActivityIdAndType(Long activityId, Integer activityType) throws TuiaMediaException;
}
