package cn.com.duiba.tuia.media.dao;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;

import java.util.List;

/**
 * Function: ActivitySortDAO
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortDAO {

    /** 新增 */
    int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException;

    /** 更新 */
    int update(ActivitySortDto activitySortDto) throws TuiaMediaException;

    /** 根据条件查询 */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /** 根据条件查询时的数量 */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /** 移除某个APP下的所有活动 */
    int deleteAppAllActivity(Long activityAppId) throws TuiaMediaException;

    /** 移除所有APP下的某一个活动 */
    int deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException;
}
