/**
 * Project Name:media-biz<br>
 * File Name:ActivityStatisticsDayDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年10月18日下午1:51:17<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.model.req.ReqActivityData;

/**
 * ClassName: ActivityStatisticsDayDAO <br/>
 * Function: 活动统计数据. <br/>
 * date: 2016年10月18日 下午1:51:17 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface ActivityStatisticsDayDAO {

    /**
     * 查询符合条件的记录总数.
     *
     * @param req the req
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByPage(ReqActivityData req) throws TuiaMediaException;

    /**
     * 查询符合条件的记录列表.
     *
     * @param req the req
     * @return the list< activity statistics day dto>
     * @throws TuiaMediaException the tuia media exception
     */
    List<ActivityStatisticsDayDto> selectListByPage(ReqActivityData req) throws TuiaMediaException;

    /**
     * 查询单个活动明细的记录总数.
     *
     * @param req the req
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByDetail(ReqActivityData req) throws TuiaMediaException;

    /**
     * 查询单个活动明细的记录列表.
     *
     * @param req the req
     * @return the list< activity statistics day dto>
     * @throws TuiaMediaException the tuia media exception
     */
    List<ActivityStatisticsDayDto> selectListByDetail(ReqActivityData req) throws TuiaMediaException;

    /**
     * 查询活动的曝光数和发券数，用来计算SPM
     * 
     * @param activityIds 活动ID列表
     * @param activityAppId 媒体ID
     */
    List<ActivityStatisticsDayDto> selectExposureAndLaunchAdvert(List<Long> activityIds,
                                                                 Long activityAppId) throws TuiaMediaException;
}
