/**
 * 文件名： BaseDAO.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 下午1:36:05
 */
package cn.com.duiba.tuia.media.dao;

import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * 基础dao
 * 
 * @author: leiliang
 * @version:
 */
public class BaseDAO {

    protected Logger             logger                   = LoggerFactory.getLogger(getClass());

    /** 批量执行做的长度. */
    public static final int      BATCH_EXECUTE_MAX_LENGTH = 100;

    @Autowired
    @Qualifier("sqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;

    protected SqlSessionTemplate getSqlSession() {
        return sqlSession;
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }
}
