/**
 * Project Name:media-biz File Name:MediaDao.java Package Name:cn.com.duiba.tuia.media.dao Date:2016年9月26日上午11:29:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;

/**
 * ClassName:MediaAppDao <br/>
 * Function: 媒体管理. <br/>
 * Date: 2016年9月26日 上午11:29:53 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface MediaAppDao {

    /**
     * 创建媒体信息.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int insert(MediaAppDto param) throws TuiaMediaException;

    /**
     * 获取媒体信息列表.
     *
     * @param mediaAppQuery the media app query
     * @return the list< rsp media app>
     * @throws TuiaMediaException the tuia media exception
     */
    List<MediaAppDto> selectMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException;

    /**
     * 修改媒体信息.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int update(ReqUpdateMediaApp param) throws TuiaMediaException;

    /**
     * 获取媒体信息.
     *
     * @param appId the app id
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto selectMediaAppById(Long appId) throws TuiaMediaException;

    /**
     * 通过appKey获取媒体信息.
     *
     * @param appKey the app key
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto selectByAppKey(String appKey) throws TuiaMediaException;

    /**
     * 查询总数.
     *
     * @param param the param
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByPageQuery(ReqPageQueryMediaApp param) throws TuiaMediaException;

    /**
     * 修改媒体信息状态.
     *
     * @param appId the app id
     * @param checkStatus the check status
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException;

    /**
     * 根据ID列表查询appId与appName的数据对象列表. <br/>
     *
     * @param ids the ids
     * @return appId appName数据对象列表
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    List<IdAndName> selectAppIdAndName(List<Long> appIds) throws TuiaMediaException;

    /**
     * 通过app名称模糊查询appID集合.
     *
     * @param appName the app name
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectIdsByName(String appName) throws TuiaMediaException;

    /**
     * 通过app名称判断是否存在重名的app.
     *
     * @param appName the app name
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto getMediaAppByName(String appName) throws TuiaMediaException;

    /**
     * 通过媒体用户Id获取所有媒体appId和appName
     * 
     * @param appIds
     * @return
     * @throws TuiaMediaException
     */
    List<IdAndName> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * 通过应用ID和NAME查询
     * 
     * @param appId 应用ID，完全匹配
     * @param appName 应用名称，模糊匹配
     */
    List<MediaAppDto> selectByIdAndName(Long appId, String appName) throws TuiaMediaException;

}
