/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDAO.java<br/>
 * Package Name:cn.com.duiba.tuia.media.dao<br/>
 * Date:2016年9月26日下午7:13:33<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;

/**
 * 广告位DAO <br/>
 * Date: 2016年9月26日 下午7:13:33 <br/>
 * .
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public interface SlotDAO {

    /**
     * 创建广告位. <br/>
     *
     * @param slotDto the slot dto
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    int insert(SlotDto slotDto) throws TuiaMediaException;

    /**
     * 修改广告位. <br/>
     *
     * @param slotDto the slot dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    int update(SlotDto slotDto) throws TuiaMediaException;

    /**
     * 查询广告位列表数据总数.
     *
     * @param param the param
     * @return int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAmountByPage(ReqSlotList param) throws TuiaMediaException;

    /**
     * 管理端查询广告位列表数据总数.
     *
     * @param param the param
     * @return int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectAdsenseAmountByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 查询广告位列表.
     *
     * @param param the param
     * @return 广告位列表
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotDto> selectListByPage(ReqSlotList param) throws TuiaMediaException;

    /**
     * 管理端查询广告位列表.
     *
     * @param param the param
     * @return 广告位列表
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotDto> selectListAdsenseByPage(ReqGetSlotsByPageDto req, List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 修改广告位开启/关闭状态. <br/>
     *
     * @param slotId 广告位ID
     * @param enableStatus 广告位开启/关闭状态
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    int updateEnableStatus(Long slotId, int enableStatus) throws TuiaMediaException;

    /**
     * 修改广告位审核状态. <br/>
     *
     * @param slotId the slot id
     * @param checkStatus the check status
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int updateCheckStatus(Long slotId, int checkStatus) throws TuiaMediaException;

    /**
     * 批量修改广告位状态. <br/>
     *
     * @param slotIds the slot ids
     * @param checkStatus the check status
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int batchUpdateCheckStatus(List<Long> slotIds, int checkStatus) throws TuiaMediaException;

    /**
     * 批量修改广告位审核状态
     * 
     * @param slotIds
     * @param enableStatus
     * @return
     * @throws TuiaMediaException
     */
    int batchUpdateEnableStatus(List<Long> slotIds, int enableStatus) throws TuiaMediaException;

    /**
     * 根据ID获取广告位信息. <br/>
     *
     * @param slotId the slot id
     * @return the slot dto
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    SlotDto selectById(Long slotId) throws TuiaMediaException;

    /**
     * 批量获取广告位集合.
     *
     * @param slotIds the slot ids
     * @return the list detail
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotDto> selectListDetail(List<Long> slotIds) throws TuiaMediaException;

    /**
     * 通过广告位名称模糊查询广告位ID集合.
     *
     * @param slotName the slot name
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectIdsByName(String slotName) throws TuiaMediaException;

    /**
     * 通过slotId批量查询slotName.
     *
     * @param slotIds the slot ids
     * @return the list< id and name>
     * @throws TuiaMediaException the tuia media exception
     */
    List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException;
}
