/**
 * Project Name:media-biz<br>
 * File Name:SlotStatisticsDAO.java<br>
 * Package Name:cn.com.duiba.tuia.media.dao<br>
 * Date:2016年10月10日下午4:32:52<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.dao;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.DataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: SlotStatisticsDAO <br/>
 * date: 2016年10月10日 下午4:32:52 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface SlotStatisticsDAO {

    /**
     * 分页统计广告位数据总数.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @param appIdsByName the app ids by name
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    int selectSlotDataAmout(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList)
                                                                                                    throws TuiaMediaException;

    /**
     * 分页统计广告位数据.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @param appIdsByName the app ids by name
     * @return the list< slot statistics dto>
     * @throws TuiaMediaException the tuia media exception
     */
    List<SlotStatisticsDto> selectListSlotDataByPage(ReqSlotStatisticsDto req, List<Long> slotIdsList,
                                                     List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 分页统计媒体应用数据总数.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @return the media data amount
     * @throws TuiaMediaException the tuia media exception
     */
    int selectMediaDataAmount(ReqMediaAppStatisticsDto req, List<Long> appIdsList) throws TuiaMediaException;

    /**
     * 分页统计媒体应用数据.
     *
     * @param req the req
     * @param slotIdsByName the slot ids by name
     * @return the media data by page
     * @throws TuiaMediaException the tuia media exception
     */
    List<MediaAppStatisticsDto> selectListMediaDataByPage(ReqMediaAppStatisticsDto req, List<Long> appIdsList)
                                                                                                              throws TuiaMediaException;

    /**
     * 根据开始日期和结束日期 获取 总的 '点击量','曝光量','eCPM','预计收入' 统计数据
     * 
     * @author guyan
     * @param startDate
     * @param endDate
     * @return
     */
    List<DataStatisticsDto> selectByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException;
}
