package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAppDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

/**
 * Function: ActivityAppDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivityAppDAOImpl extends BaseDAO implements ActivityAppDAO {

    @Override
    public int insertBatch(List<ActivityAppDto> activityAppDtoList) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), activityAppDtoList);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.insert data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ActivityAppDto activityAppDto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), activityAppDto);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityAppDto> selectByCondition(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByCondition"), reqActivityApp);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.selectByCondition happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByConditionAmount"), reqActivityApp);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.selectByConditionAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int delete(Long activityAppId) throws TuiaMediaException {
        try {
            HashMap map = new HashMap(2);
            map.put("activityAppId", activityAppId);
            map.put("isDelete", true);
            return getSqlSession().update(getStamentNameSpace("delete"), map);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityAppDto> selectByActivityAppIds(List<Long> ids) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByActivityAppIds"), ids);
        } catch (Exception e) {
            logger.error("ActivityAppDAOImpl.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
