package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

/**
 * Function: ActivityDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivityDAOImpl extends BaseDAO implements ActivityDAO {

    @Override
    public int insertBatch(List<ActivityDto> activityDtoList) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), activityDtoList);
        } catch (Exception e) {
            logger.error("ActivityDAO.insert data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ActivityDto activityDto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), activityDto);
        } catch (Exception e) {
            logger.error("ActivityDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivityDto> selectByActivityIds(List<Long> activityIds) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByActivityIds"), activityIds);
        } catch (Exception e) {
            logger.error("ActivityDAO.selectByActivityIds happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<Long> selectByTypeAndName(String name, Integer type) throws TuiaMediaException {
        try {
            HashMap map = new HashMap(2);
            map.put("name", name);
            map.put("type", type);
            return getSqlSession().selectList(getStamentNameSpace("selectByTypeAndName"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.selectByTypeAndName happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public ActivityDto selectByActivityIdAndType(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap map = new HashMap(2);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().selectOne(getStamentNameSpace("selectByActivityIdAndType"), map);
        } catch (Exception e) {
            logger.error("ActivityDAO.selectByActivityIdAndType happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
