package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

/**
 * Function: ActivitySortDAOImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Repository
public class ActivitySortDAOImpl extends BaseDAO implements ActivitySortDAO {

    @Override
    public int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        try {
            return getSqlSession().insert(getStamentNameSpace("insertBatch"), activitySortDtoList);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.insert data happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ActivitySortDto activitySortDto) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), activitySortDto);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.update happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectByCondition"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByCondition happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectByConditionAmount"), reqActivitySort);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.selectByConditionAmount happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteAppAllActivity(Long activityAppId) throws TuiaMediaException {
        try {
            return getSqlSession().delete(getStamentNameSpace("deleteAppAllActivity"), activityAppId);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap map = new HashMap(3);
            map.put("activityAppId", activityAppId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return getSqlSession().delete(getStamentNameSpace("deleteActivity"), map);
        } catch (Exception e) {
            logger.error("ActivitySortDAO.delete happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
