/**
 * Project Name:media-biz File Name:MediaAppConfigDaoImpl.java Package Name:cn.com.duiba.tuia.media.dao.impl
 * Date:2016年10月8日下午7:53:59 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppConfigDao;

/**
 * ClassName:MediaAppConfigDaoImpl <br/>
 * Function: 媒体配置信息. <br/>
 * Date: 2016年10月8日 下午7:53:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("mediaAppConfigDao")
public class MediaAppConfigDaoImpl extends BaseDAO implements MediaAppConfigDao {

    @Override
    public int insert(MediaAppConfigDto param) throws TuiaMediaException {
        try {
            param.setGmtCreate(new Date());
            param.setGmtModified(param.getGmtCreate());
            return getSqlSession().insert(getStamentNameSpace("insert"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.createMediaAppConfig happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public List<MediaAppDto> selectMediaAppConfigList(ReqGetMediaAppConfigByPageDto param) throws TuiaMediaException {
        try {
            return getSqlSession().selectList(getStamentNameSpace("selectMediaAppConfigList"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.getMediaAppConfigList happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int update(ReqUpdateMediaAppConfigDto param) throws TuiaMediaException {
        try {
            return getSqlSession().update(getStamentNameSpace("update"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.updateMediaAppConfig happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public MediaAppConfigDto selectMediaAppConfigById(Long appId) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectMediaAppConfigById"), appId);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.selectMediaAppConfigById happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

    @Override
    public int selectAmountByPageQuery(ReqGetMediaAppConfigByPageDto param) throws TuiaMediaException {
        try {
            return getSqlSession().selectOne(getStamentNameSpace("selectAmountByPageQuery"), param);
        } catch (Exception e) {
            logger.error("MediaAppConfigDaoImpl.selectAmountByPageQuery happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }
}
