/**
 * Project Name:tuia-dao<br>
 * File Name:OperateLogDAOImpl.java<br>
 * Package Name:cn.com.duiba.tuia.dao.operate_log.impl<br>
 * Date:2016年8月12日下午3:30:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.dao.impl;

import java.util.Date;

import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.OperateLogDAO;
import cn.com.duiba.tuia.media.domain.OperateLogDto;

/**
 * ClassName: OperateLogDAOImpl <br/>
 * Function: 操作日志. <br/>
 * date: 2016年8月12日 下午3:30:04 <br/>
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 */
@Repository("operateLogDAO")
public class OperateLogDAOImpl extends BaseDAO implements OperateLogDAO {

    @Override
    public int insert(OperateLogDto record) throws TuiaMediaException {
        try {
            record.setGmtCreate(new Date());
            return getSqlSession().insert(getStamentNameSpace("insert"), record);
        } catch (Exception e) {
            logger.error("OperateLogDAO.insert happen [DB] error!", e);
            throw new TuiaMediaException(ErrorCode.E0002001, e);
        }
    }

}
