/**
 * Project Name:media-biz<br>
 * File Name:ReqLogin.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年10月17日下午2:41:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.model.req;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqLogin <br/>
 * date: 2016年10月17日 下午2:41:45 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqLogin {

    @ApiModelProperty(value = "邮箱", required = true)
    @NotBlank(message = "邮箱不能为空")
    @Email(message = "邮箱格式错误")
    private String  email;

    @ApiModelProperty(value = "密码", required = true)
    @NotBlank(message = "密码不能为空")
    private String  password;

    @ApiModelProperty(value = "记住账号", required = true)
    private boolean remember;

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * password.
     *
     * @return the password
     * @since JDK 1.6
     */
    public String getPassword() {
        return password;
    }

    /**
     * password.
     *
     * @param password the password to set
     * @since JDK 1.6
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * remember.
     *
     * @return the remember
     * @since JDK 1.6
     */
    public boolean isRemember() {
        return remember;
    }

    /**
     * remember.
     *
     * @param remember the remember to set
     * @since JDK 1.6
     */
    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
