/**
 * 
 */
package cn.com.duiba.tuia.media.model.rsp;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 此类描述的是：分页查询共用返回结果.
 *
 * @param <T> the generic type
 * @author: leiliang
 * @version: 2016年2月25日 下午3:06:54
 */
public class RspPageResult<T> {

    /** 总数. */
    private int     totalCount;

    /** 总页数. */
    private int     totalPage;

    /** The data. */
    private List<T> list;

    public RspPageResult() {
        super();
    }

    /**
     * The Constructor.
     *
     * @param totalAmount 总记录数
     * @param data 数据列表
     * @param pageSize 每页记录数
     */
    public RspPageResult(int totalAmount, List<T> list, int pageSize) {
        super();
        this.totalCount = totalAmount;
        this.list = list;
        this.totalPage = setToalPage(pageSize);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setToalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }

        return (totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    /**
     * Gets the total page.
     *
     * @return the total page
     */
    public int getTotalPage() {
        return totalPage;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
