/**
 * Project Name:media-biz<br>
 * File Name:ShieldStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.rsp<br>
 * Date:2016年9月27日下午4:31:29<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.model.rsp;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ShieldStrategy <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月27日 下午4:31:29 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RspShieldStrategy extends BaseStrategy {

    /** 屏蔽行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽行业列表，中间以逗号隔开", required = false)
    private List<String> shieldIndustries;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告主URL列表， 中间以逗号隔开", required = false)
    private List<String> shieldAdvertisers;

    private boolean      industryFlag   = false;

    private boolean      advertiserFlag = false;

    /**
     * industryFlag.
     *
     * @return the industryFlag
     * @since JDK 1.6
     */
    public boolean isIndustryFlag() {
        return industryFlag;
    }

    /**
     * industryFlag.
     *
     * @param industryFlag the industryFlag to set
     * @since JDK 1.6
     */
    public void setIndustryFlag(boolean industryFlag) {
        this.industryFlag = industryFlag;
    }

    /**
     * advertiserFlag.
     *
     * @return the advertiserFlag
     * @since JDK 1.6
     */
    public boolean isAdvertiserFlag() {
        return advertiserFlag;
    }

    /**
     * advertiserFlag.
     *
     * @param advertiserFlag the advertiserFlag to set
     * @since JDK 1.6
     */
    public void setAdvertiserFlag(boolean advertiserFlag) {
        this.advertiserFlag = advertiserFlag;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
