package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityAppBackendService;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.service.ActivityAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivityAppBackendServiceImpl extends BaseRemoteService implements RemoteActivityAppBackendService {

    @Autowired
    private ActivityAppService activityAppService;

    @Override
    public DubboResult<PageResultDto<RspActivityAppDto>> getActivityAppByPage(ReqActivityApp reqActivityApp) {
        try {
            List<ActivityAppDto> result = activityAppService.selectByCondition(reqActivityApp);
            if (result == null) {
                return DubboResult.successResult(null);
            }
            List<RspActivityAppDto> rspActivityAppDtoList = new ArrayList(result.size());
            for (ActivityAppDto activityAppDto : result) {
                RspActivityAppDto rspActivityDto = new RspActivityAppDto();
                rspActivityDto.setId(activityAppDto.getActivityAppId());
                rspActivityDto.setName(activityAppDto.getActivityAppName());
                rspActivityAppDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult(new PageResultDto<>(activityAppService.selectByConditionAmount(reqActivityApp),
                                                                 rspActivityAppDtoList, reqActivityApp.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivityAppBackendServiceImpl.getActivityAppByPage is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivityApp(List<Long> activityAppIds) {
        try {
            return DubboResult.successResult(activityAppService.insertBatchActivityApp(activityAppIds));
        } catch (Exception e) {
            logger.error("RemoteActivityAppBackendServiceImpl.addActivityApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> removeActivityApp(Long activityAppId) {
        try {
            return DubboResult.successResult(activityAppService.deleteActivityApp(activityAppId));
        } catch (Exception e) {
            logger.error("RemoteActivityAppBackendServiceImpl.removeActivityApp is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspActivityAppDto>> searchActivityApp(ReqActivityApp reqActivityApp) {
        try {
            return DubboResult.successResult(activityAppService.searchActivityApp(reqActivityApp));
        } catch (Exception e) {
            logger.error("RemoteActivityAppBackendServiceImpl.removeActivityApp is error", e);
            return exceptionFailure(e);
        }
    }
}
