package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityBackendService;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivityBackendServiceImpl extends BaseRemoteService implements RemoteActivityBackendService {

    @Autowired
    private ActivityService activityService;

    @Override
    public DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds) {
        try {
            List<ActivityDto> result = activityService.selectByActivityIds(activityIds);
            if (result == null) {
                return DubboResult.successResult(null);
            }
            List<RspActivityDto> rspActivityDtoList = new ArrayList(result.size());
            for (ActivityDto activityDto : result) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setId(activityDto.getActivityId());
                rspActivityDto.setName(activityDto.getActivityName());
                rspActivityDto.setType(activityDto.getActivityType());
                rspActivityDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult(rspActivityDtoList);
        } catch (Exception e) {
            logger.error("RemoteActivityBackendServiceImpl.getByActivityIds is error");
            return exceptionFailure(e);
        }
    }
}
