package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.common.constants.ActivityStatusConstant;
import cn.com.duiba.tuia.media.common.constants.ActivityTypeConstant;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public class RemoteActivitySortBackendServiceImpl extends BaseRemoteService implements RemoteActivitySortBackendService {

    // 同一媒体下连续添加两个活动之间的排序值的差
    private static final long            TIME_DIFFER = 1000000;

    @Autowired
    private ActivitySortService          activitySortService;
    @Autowired
    private ActivityService              activityService;
    @Autowired
    private ActivityStatisticsDayService activityStatisticsDayService;

    @Override
    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            List<ActivitySortDto> result = activitySortService.selectByCondition(reqActivitySort);
            if (result == null || result.size() == 0) {
                return DubboResult.successResult(new PageResultDto<>(0, new ArrayList<RspActivityDto>(),
                                                                     reqActivitySort.getPageSize()));
            }
            List<ActivityDto> activityDtoList = activityService.selectByActivityIds(CollectionUtil.getFieldList(result,
                                                                                                                "activityId"));
            Map<Long, ActivityDto> activityMap = new HashMap(activityDtoList.size());
            for (ActivityDto activityDto : activityDtoList) {
                activityMap.put(activityDto.getActivityId(), activityDto);
            }
            List<RspActivityDto> rspActivityDtoList = new ArrayList(result.size());
            List<ActivityStatisticsDayDto> activityStatisticsDayDtoList = activityStatisticsDayService.selectExposureAndLaunchAdvert(CollectionUtil.getFieldList(result,
                                                                                                                                                                 "activityId"),
                                                                                                                                     reqActivitySort.getAppId());
            // 查询活动的发券数量和曝光数，用来计算SPM
            Map<Long, Long> spmMap = new HashMap(activityStatisticsDayDtoList.size());
            for (ActivityStatisticsDayDto activityStatisticsDayDto : activityStatisticsDayDtoList) {
                spmMap.put(activityStatisticsDayDto.getDuibaActivityId(),
                           DataTool.calculateEcpm(activityStatisticsDayDto.getLaunchAdvertCount(),
                                                  activityStatisticsDayDto.getExposureCount()));
            }
            for (ActivitySortDto activitySortDto : result) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setId(activitySortDto.getActivityId());
                if (activityMap.get(activitySortDto.getActivityId()) != null) {
                    rspActivityDto.setName(activityMap.get(activitySortDto.getActivityId()).getActivityName());
                    rspActivityDto.setStatus(ActivityStatusConstant.getStatusText(activityMap.get(activitySortDto.getActivityId()).getActivityStatus()));
                    rspActivityDto.setType(activityMap.get(activitySortDto.getActivityId()).getActivityType());
                    rspActivityDto.setTypeName(ActivityTypeConstant.getTypeText(activityMap.get(activitySortDto.getActivityId()).getActivityType()));
                    rspActivityDto.setSpm(spmMap.get(activitySortDto.getActivityId()));
                }
                rspActivityDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult(new PageResultDto<>(activitySortService.selectByConditionAmount(reqActivitySort),
                                                                 rspActivityDtoList, reqActivitySort.getPageSize()));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addActivitySort(Long activityAppId, List<ReqIdAndType> idAndTypes) {
        try {
            // 需要将当前时间戳与数据库最大排序值比较，若时间戳小于数据库最大值，则需要处理
            Long sort = new Date().getTime();
            ActivitySortDto result = activitySortService.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null) {
                if (result.getActivitySort() >= sort) {
                    sort = result.getActivitySort() + TIME_DIFFER;
                }
            }
            // 查询已有活动列表
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            List<ActivitySortDto> existList = activitySortService.selectByCondition(reqActivitySort);
            HashMap<String, Long> map = new HashMap(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                map.put(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString(),
                        activitySortDto.getActivitySort());
            }
            // 查询需要添加活动列表
            List<ActivityDto> activityDtoList = activityService.selectByActivityIds(CollectionUtil.getFieldList(idAndTypes,
                                                                                                                "id"));
            List<ActivitySortDto> activitySortDtoList = new ArrayList();
            for (ActivityDto activityDto : activityDtoList) {
                // 如果已经添加过则不添加
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(activityDto.getActivityId());
                reqIdAndType.setType(activityDto.getActivityType());
                if (map.get(activityDto.getActivityId() + activityDto.getActivityType().toString()) == null
                    && CollectionUtil.haveSame(idAndTypes, Lists.newArrayList(reqActivitySort))) {
                    ActivitySortDto activitySortDto = new ActivitySortDto();
                    activitySortDto.setActivityAppId(activityAppId);
                    activitySortDto.setActivityType(activityDto.getActivityType());
                    activitySortDto.setActivityId(activityDto.getActivityId());
                    activitySortDto.setActivitySort(sort);
                    sort += TIME_DIFFER;
                    activitySortDtoList.add(activitySortDto);
                }
            }
            if (activitySortDtoList.size() > 0) {
                activitySortService.insertBatchActivitySort(activitySortDtoList);
            }
            return DubboResult.successResult(true);
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendServiceImpl.addActivitySort is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> addDefaultActivitySort(Long activityAppId) {
        List<ReqIdAndType> idAndTypes = new ArrayList<>();
        try {
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(0L);
            List<ActivitySortDto> defaultList = activitySortService.selectByCondition(reqActivitySort);
            for (ActivitySortDto activitySortDto : defaultList) {
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(activitySortDto.getActivityId());
                reqIdAndType.setType(activitySortDto.getActivityType());
                idAndTypes.add(reqIdAndType);
            }
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendServiceImpl.addDefaultActivitySort is error");
            return exceptionFailure(e);
        }
        return addActivitySort(activityAppId, idAndTypes);
    }

    @Override
    public DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(activitySortService.deleteActivity(activityAppId, activityId,
                                                                                activityType));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> sort(Long activityAppId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult(activitySortService.sort(activityAppId, activityId, activityType,
                                                                      location));
        } catch (Exception e) {
            logger.error("RemoteActivitySortBackendServiceImpl.sort is error");
            return exceptionFailure(e);
        }
    }
}
