/**
 * Project Name:media-biz File Name:RemoteMediaAppService.java Package Name:cn.com.duiba.tuia.media.remoteservice
 * Date:2016年9月30日下午4:02:06 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.remoteservice;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaAppBackendService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppService <br/>
 * Function: tuia媒体app信息服务. <br/>
 * Date: 2016年9月30日 下午4:02:06 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class RemoteMediaAppBackendServiceImpl extends BaseRemoteService implements RemoteMediaAppBackendService {

    @Autowired
    MediaAppService mediaAppService;

    @Override
    public DubboResult<Boolean> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) {
        try {
            return DubboResult.successResult(this.mediaAppService.updateMediaAppStatus(param));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.updateMediaAppStatus is error", e);
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<MediaAppDto> getMediaApp(Long appId) {
        try {
            return DubboResult.successResult(this.mediaAppService.getMediaAppDto(appId));
        } catch (Exception e) {
            logger.error("RemoteMediaAppBackendServiceImpl.getMediaApp is error", e);
            return exceptionFailure(e);
        }
    }

}
