/**
 * Project Name:media-biz<br>
 * File Name:RemoteSlotBackendServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br>
 * Date:2016年9月30日下午4:34:39<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteSlotBackendService;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteSlotBackendServiceImpl <br/>
 * Function: 广告位. <br/>
 * date: 2016年9月30日 下午4:34:39 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RemoteSlotBackendServiceImpl extends BaseRemoteService implements RemoteSlotBackendService {

    @Autowired
    private SlotService   slotService;

    @Autowired
    private SlotBackendBo slotBackendBo;

    @Override
    public DubboResult<RspSlotDetailDto> getDetail(long slotId) {
        try {
            return DubboResult.successResult(slotBackendBo.getBackendSlotDetailById(slotId));
        } catch (Exception e) {
            logger.error("RemoteSlotBackendService.getDetail is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspAdsenseSlotListDto>> getSlotsByPage(ReqGetSlotsByPageDto req) {
        try {
            return DubboResult.successResult(slotService.selectAdsenseListByPage(req));
        } catch (Exception e) {
            logger.error("RemoteSlotBackendService.getSlotsByPage is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> batchUpdateCheckStatus(List<Long> slotIds, int status) {
        try {
            return DubboResult.successResult(slotBackendBo.batchUpdateCheckStatus(slotIds, status));
        } catch (Exception e) {
            logger.error("RemoteSlotBackendService.batchUpdateCheckStatus is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds) {
        try {
            return DubboResult.successResult(slotService.getListDetail(slotIds));
        } catch (Exception e) {
            logger.error("RemoteSlotBackendService.getListDetail is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<Boolean> update(ReqUpdateSlotStrategy param) {
        try {
            return DubboResult.successResult(slotBackendBo.updateSlotStrategy(param));
        } catch (Exception e) {
            logger.error("RemoteSlotBackendService.update is error");
            return exceptionFailure(e);
        }
    }

}
