/**
 * Project Name:media-biz<br>
 * File Name:RemoteStatisticstBackendServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.remoteservice<br>
 * Date:2016年10月10日下午4:19:44<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.remoteservice;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetActivityData;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityDetailData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotStatisticsDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteStatisticstBackendService;
import cn.com.duiba.tuia.media.bo.ActivityStatisticsDayBO;
import cn.com.duiba.tuia.media.bo.SlotStatisticsBackendBO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteStatisticstBackendServiceImpl <br/>
 * date: 2016年10月10日 下午4:19:44 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RemoteStatisticstBackendServiceImpl extends BaseRemoteService implements RemoteStatisticstBackendService {

    @Autowired
    private SlotStatisticsBackendBO slotStatisticsBackendBO;

    @Autowired
    private ActivityStatisticsDayBO activityStatisticsDayBO;

    @Override
    public DubboResult<PageResultDto<RspSlotStatisticsDto>> getAdsenseData(ReqSlotStatisticsDto req) {
        try {
            return DubboResult.successResult(slotStatisticsBackendBO.getAdsenseData(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getAdsenseData is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspMediaAppStatisticsDto>> getMediaData(ReqMediaAppStatisticsDto req) {
        try {
            return DubboResult.successResult(slotStatisticsBackendBO.getMediaData(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getMediaData is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspGetActivityData>> getActivityDataByPage(ReqGetActivityData req) {
        try {
            return DubboResult.successResult(activityStatisticsDayBO.getActivityDataByPage(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getActivityData is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<PageResultDto<RspGetActivityDetailData>> getActivityDetailDataByPage(ReqGetActivityData req) {
        try {
            return DubboResult.successResult(activityStatisticsDayBO.getActivityDetailDataByPage(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getActivityDetailData is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspGetActivityData>> getActivityDataList(ReqGetActivityData req) {
        try {
            return DubboResult.successResult(activityStatisticsDayBO.getActivityDataList(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getActivityDataList is error");
            return exceptionFailure(e);
        }
    }

    @Override
    public DubboResult<List<RspGetActivityDetailData>> getActivityDetailDataList(ReqGetActivityData req) {
        try {
            return DubboResult.successResult(activityStatisticsDayBO.getActivityDetailDataList(req));
        } catch (Exception e) {
            logger.error("RemoteStatisticstBackendService.getActivityDetailDataList is error");
            return exceptionFailure(e);
        }
    }

}
