/**
 * Project Name:media-biz<br>
 * File Name:AccountService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月26日上午10:46:34<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountBaseDto;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;
import cn.com.duiba.tuia.media.model.rsp.TokenRsp;

/**
 * ClassName: AccountService <br/>
 * date: 2016年9月26日 上午10:46:34 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountService {

    /**
     * 媒体账户邮箱是否存在.
     *
     * @param email the email
     * @return true, if checks if is email exists
     * @throws TuiaMediaException the tuia media exception
     */
    boolean isEmailExists(String email) throws TuiaMediaException;

    /**
     * Checks if is phone exists.
     *
     * @param linkPhone the link phone
     * @return true, if checks if is phone exists
     * @throws TuiaMediaException the tuia media exception
     */
    AccountDto isPhoneExists(String linkPhone) throws TuiaMediaException;

    /**
     * 重新提交时验证手机号是否已经存在.
     *
     * @param linkPhone the link phone
     * @param mediaId the media id
     * @return true, if repeat register verify phone
     * @throws TuiaMediaException the tuia media exception
     */
    boolean repeatRegisterVerifyPhone(String linkPhone, Long mediaId) throws TuiaMediaException;

    /**
     * 插入媒体账户基本信息.
     *
     * @param accountDto the account dto
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    boolean insertAccountBase(AccountDto accountDto) throws TuiaMediaException;

    /**
     * 通过媒体账户ID获取媒体账户基本信息.
     *
     * @param mediaId the media id
     * @return the account dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountDto selectByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * 根据邮箱查询媒体账户信息.
     *
     * @param email the email
     * @return the account dto
     * @throws TuiaMediaException the tuia media exception
     */
    AccountDto selectByEmail(String email) throws TuiaMediaException;

    /**
     * 重新提交媒体账户审核信息.
     *
     * @param req the req
     * @return the int
     * @throws TuiaMediaException the tuia media exception
     */
    boolean updateAuditData(AccountDto req) throws TuiaMediaException;

    /**
     * 发送重置密码邮件.
     *
     * @param email the email
     * @return true, if send reset passwd email
     * @throws TuiaMediaException 失败抛出异常
     */
    boolean sendResetPasswdEmail(String email) throws TuiaMediaException;

    /**
     * 发送更换邮箱邮件.
     *
     * @param email the email
     * @param userId the user id
     * @return true, if send reset passwd email
     * @throws TuiaMediaException 失败抛出异常
     */
    boolean sendReplaceEmail(String email, Long userId) throws TuiaMediaException;

    /**
     * 更换邮箱.
     *
     * @param token the token
     * @param userId the user id
     * @return true, if send reset passwd email
     * @throws TuiaMediaException 失败抛出异常
     */
    boolean replaceEmail(String token, Long userId) throws TuiaMediaException;

    /**
     * 重置密码邮件链接跳转地址 <一句话功能描述>.
     *
     * @param email the email
     * @param verificationCode the verificationCode
     * @return the token rsp
     * @throws TuiaMediaException the tuia exception
     */
    TokenRsp resetPasswdRedirect(String email, String verificationCode) throws TuiaMediaException;

    /**
     * 重置密码.
     *
     * @param email 邮箱
     * @param newPasswd 新密码
     * @param token 重置密码邮件中的token
     * @return true, if reset password
     * @throws TuiaMediaException the tuia media exception
     */
    boolean resetPassword(String email, String newPasswd, String token) throws TuiaMediaException;

    /**
     * 注册后邮箱验证邮件.
     *
     * @param token the token
     * @return the map< string, object>
     * @throws TuiaMediaException the tuia media exception
     */
    void verifyEmail(String token) throws TuiaMediaException;

    /**
     * 重新发送注册邮箱验证邮件.
     *
     * @param email the email
     * @throws TuiaMediaException the tuia media exception
     */
    void repeatVerifyEmail(String email) throws TuiaMediaException;

    /**
     * 更新媒体用户信息.
     *
     * @param req the req
     * @return true, if update account base
     * @throws TuiaMediaException the tuia media exception
     */
    boolean updateAccountBase(ReqUpdateAccountBase req) throws TuiaMediaException;

    /**
     * 更新媒体财务信息.
     *
     * @param req the req
     * @return true, if update account bank
     * @throws TuiaMediaException the tuia media exception
     */
    boolean updateAccountBank(ReqUpdateAccountBank req) throws TuiaMediaException;

    /**
     * 分页查询媒体账户信息.
     *
     * @param req the req
     * @return the rsp page result< rsp account base>
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspAccountBaseDto> pageQuery(ReqGetAccountByPageDto req) throws TuiaMediaException;

    /**
     * 账号审核.
     *
     * @param mediaId the media id
     * @param checkType 账号审核状态
     * @return true, if update check status
     * @throws TuiaMediaException the media manager exception
     */
    boolean updateCheckStatus(Long mediaId, Integer checkType) throws TuiaMediaException;

    /**
     * 账号冻结.
     *
     * @param mediaId the media id
     * @param checkType the check type
     * @return true, if update freeze status
     * @throws TuiaMediaException the media manager exception
     */
    boolean updateFreezeStatus(Long mediaId, Integer checkType) throws TuiaMediaException;

    /**
     * 根据用户ID查询用户信息(用户不存在抛出异常).
     *
     * @param mediaId 媒体用户ID
     * @return 用户信息
     * @throws TuiaMediaException the tuia media exception
     */
    AccountDto selectByIdNotNull(Long mediaId) throws TuiaMediaException;

    /**
     * 判断accountDto是否为空.
     *
     * @param dto the dto
     * @throws TuiaMediaException the tuia media exception
     */
    void accountDtoIsNull(AccountDto dto) throws TuiaMediaException;

    /**
     * 发送邮箱激活邮件.
     *
     * @param accountDto the account dto
     */
    void doSendVerifyEmail(final AccountDto accountDto);
}
