package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;

import java.util.List;

/**
 * Function: ActivityAppService
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityAppService {

    /** 新增活动媒体 */
    boolean insertBatchActivityApp(List<Long> activityAppIds) throws TuiaMediaException;

    /** 更新活动媒体 */
    boolean updateActivityApp(ActivityAppDto activityAppDto) throws TuiaMediaException;

    /** 根据条件查询 */
    List<ActivityAppDto> selectByCondition(ReqActivityApp reqActivityApp) throws TuiaMediaException;

    /** 根据条件查询时的总数 */
    int selectByConditionAmount(ReqActivityApp reqActivityApp) throws TuiaMediaException;

    /** 删除活动媒体 */
    boolean deleteActivityApp(Long activityAppId) throws TuiaMediaException;

    /** 添加定制媒体时的搜索接口 */
    List<RspActivityAppDto> searchActivityApp(ReqActivityApp reqActivityApp) throws TuiaMediaException;
}
