package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;

import java.util.List;

/**
 * Function: ActivityService
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivityService {

    /** 新增活动 */
    boolean insertActivity(List<ActivityDto> activityDtoList) throws TuiaMediaException;

    /** 更新活动 */
    boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException;

    /** 根据活动ID列表查询 */
    List<ActivityDto> selectByActivityIds(List<Long> activityIds) throws TuiaMediaException;

    /** 查询唯一活动记录 */
    ActivityDto selectByActivityIdAndType(Long activityId, Integer activityType) throws TuiaMediaException;
}
