package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;

import java.util.List;

/**
 * Function: ActivitySortService
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public interface ActivitySortService {

    /** 批量添加活动 */
    boolean insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException;

    /** 根据条件查询 */
    List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /** 根据条件查询时的数量 */
    int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException;

    /** 移除定制活动 */
    boolean deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException;

    /** 获取某一媒体下所有活动中排序值最大的一个 */
    ActivitySortDto getMaxSortValueActivitySortDto(Long activityAppId) throws TuiaMediaException;

    /** 排序方法 */
    boolean sort(Long activityAppId, Long activityId, Integer activityType, int location) throws TuiaMediaException;
}
