/**
 * Project Name:media-biz<br>
 * File Name:StrategyService.java<br>
 * Package Name:cn.com.duiba.tuia.media.service<br>
 * Date:2016年9月27日上午11:39:40<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspStrategyList;

/**
 * ClassName: StrategyService <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年9月27日 上午11:39:40 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface StrategyService {

    /**
     * 分页查询屏蔽策略列表.
     *
     * @param req the req
     * @return the page list
     * @throws TuiaMediaException the tuia media exception
     */
    RspPageResult<RspStrategyList> getPageList(ReqStrategyPageQuery req) throws TuiaMediaException;

    /**
     * 删除屏蔽策略.
     *
     * @param mediaId 媒体用户ID
     * @param strategyId 屏蔽策略id
     * @return true, if delete
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean delete(Long mediaId, Long strategyId) throws TuiaMediaException;

    /**
     * 创建屏蔽策略.
     *
     * @param req the req
     * @return true, if creates the
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean create(ReqShieldListStrategy req) throws TuiaMediaException;

    /**
     * 更新屏蔽策略.
     *
     * @param req the req
     * @return true, if update
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean update(ReqShieldListStrategy req) throws TuiaMediaException;
    
    /**
     * 更新广告位屏蔽策略.
     *
     * @param param the param
     * @return true, if update slot strategy
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean updateSlotStrategy(ReqShieldListStrategy param) throws TuiaMediaException;

    /**
     * 获取屏蔽策略详情.
     *
     * @param strategyId the strategy id
     * @return the list
     * @throws TuiaMediaException the tuia media exception
     */
    RspShieldStrategy getDetail(Long strategyId) throws TuiaMediaException;

    /**
     * 获取屏蔽策略列表.
     *
     * @param mediaId 媒体用户Id
     * @return the list
     * @throws TuiaMediaException the tuia media exception
     */
    List<RspIdAndValue> getListByMediaId(Long mediaId) throws TuiaMediaException;
}
