package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAppDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.service.ActivityAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Function: ActivityAppServiceImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Service
public class ActivityAppServiceImpl implements ActivityAppService {

    @Autowired
    private ActivityAppDAO  activityAppDAO;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private MediaAppDao     mediaAppDao;

    @Override
    @Transactional
    public boolean insertBatchActivityApp(List<Long> activityAppIds) throws TuiaMediaException {
        List<IdAndName> apps = mediaAppDao.selectAppIdAndName(activityAppIds);
        if (apps != null && apps.size() > 0) {
            List<ActivityAppDto> existApp = activityAppDAO.selectByActivityAppIds(activityAppIds);
            HashMap map = new HashMap(existApp.size());
            for (ActivityAppDto activityAppDto : existApp) {
                map.put(activityAppDto.getActivityAppId(), activityAppDto.getActivityAppName());
            }
            List<ActivityAppDto> activityAppDtoList = new ArrayList<>(apps.size());
            for (IdAndName idAndName : apps) {
                if (map.get(idAndName.getId()) == null) {
                    // 需要剔除已经存在的活动媒体
                    ActivityAppDto activityAppDto = new ActivityAppDto();
                    activityAppDto.setActivityAppId(idAndName.getId());
                    activityAppDto.setActivityAppName(idAndName.getName());
                    activityAppDtoList.add(activityAppDto);
                }
            }
            if (activityAppDtoList != null && activityAppDtoList.size() > 0) {
                activityAppDAO.insertBatch(activityAppDtoList);
            }
        }
        return true;
    }

    @Override
    public boolean updateActivityApp(ActivityAppDto activityAppDto) throws TuiaMediaException {
        if (activityAppDto.getActivityAppId() == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        return activityAppDAO.update(activityAppDto) == 1 ? true : false;
    }

    @Override
    public List<ActivityAppDto> selectByCondition(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        return activityAppDAO.selectByCondition(reqActivityApp);
    }

    @Override
    public int selectByConditionAmount(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        return activityAppDAO.selectByConditionAmount(reqActivityApp);
    }

    @Override
    @Transactional
    public boolean deleteActivityApp(Long activityAppId) throws TuiaMediaException {
        if (activityAppId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        activityAppDAO.delete(activityAppId);
        // 删除活动媒体时需要删除媒体定制活动列表
        activitySortDAO.deleteAppAllActivity(activityAppId);
        return true;
    }

    @Override
    public List<RspActivityAppDto> searchActivityApp(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        List<MediaAppDto> appDtoList = mediaAppDao.selectByIdAndName(reqActivityApp.getId(), reqActivityApp.getName());
        if (appDtoList == null || appDtoList.size() == 0) {
            return null;
        }
        List<RspActivityAppDto> rspActivityAppDtoList = new ArrayList(appDtoList.size());
        for (MediaAppDto mediaAppDto : appDtoList) {
            RspActivityAppDto rspActivityAppDto = new RspActivityAppDto();
            rspActivityAppDto.setId(mediaAppDto.getAppId());
            rspActivityAppDto.setName(mediaAppDto.getAppName());
            rspActivityAppDtoList.add(rspActivityAppDto);
        }
        return rspActivityAppDtoList;
    }
}
