package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Function: ActivityServiceImpl
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@Service
public class ActivityServiceImpl implements ActivityService {

    @Autowired
    private ActivityDAO activityDAO;

    @Override
    @Transactional
    public boolean insertActivity(List<ActivityDto> activityDtoList) throws TuiaMediaException {
        activityDAO.insertBatch(activityDtoList);
        return true;
    }

    @Override
    public boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException {
        return activityDAO.update(activityDto) == 1 ? true : false;
    }

    @Override
    public List<ActivityDto> selectByActivityIds(List<Long> activityIds) throws TuiaMediaException {
        return activityDAO.selectByActivityIds(activityIds);
    }

    @Override
    public ActivityDto selectByActivityIdAndType(Long activityId, Integer activityType) throws TuiaMediaException {
        return activityDAO.selectByActivityIdAndType(activityId, activityType);
    }
}
