/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.message.producer;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class ActivityKafkaProducer
implements InitializingBean {
    private String kafkaServers = "dev.config.duibar.com:9092";
    private Producer<String, String> producer;

    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.kafkaServers);
        props.put("acks", "all");
        props.put("retries", (Object)3);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)0);
        props.put("request.timeout.ms", (Object)30000);
        props.put("metadata.fetch.timeout.ms", (Object)10000);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(props);
    }

    public String sendMessage(String queueName, String body) throws Exception {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        Future future = this.producer.send(new ProducerRecord(queueName, (Object)id, (Object)body), new Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            }
        });
        future.get();
        return id;
    }

    public static void main(String[] args) throws Exception {
        ActivityKafkaProducer client = new ActivityKafkaProducer();
        client.afterPropertiesSet();
        client.sendMessage("businessActivityInformationChangeTopicDev", "bbbb");
    }
}

