/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityAppBackendService;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivityAppBackendServiceImpl
extends BaseRemoteService
implements RemoteActivityAppBackendService {
    @Autowired
    private ActivityAppService activityAppService;

    public DubboResult<PageResultDto<RspActivityAppDto>> getActivityAppByPage(ReqActivityApp reqActivityApp) {
        try {
            List<ActivityAppDto> result = this.activityAppService.selectByCondition(reqActivityApp);
            if (result == null) {
                return DubboResult.successResult(null);
            }
            ArrayList<RspActivityAppDto> rspActivityAppDtoList = new ArrayList<RspActivityAppDto>(result.size());
            for (ActivityAppDto activityAppDto : result) {
                RspActivityAppDto rspActivityDto = new RspActivityAppDto();
                rspActivityDto.setId(activityAppDto.getActivityAppId());
                rspActivityDto.setName(activityAppDto.getActivityAppName());
                rspActivityAppDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult((Object)new PageResultDto(this.activityAppService.selectByConditionAmount(reqActivityApp), rspActivityAppDtoList, reqActivityApp.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityAppBackendServiceImpl.getActivityAppByPage is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivityApp(List<Long> activityAppIds) {
        try {
            return DubboResult.successResult((Object)this.activityAppService.insertBatchActivityApp(activityAppIds));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityAppBackendServiceImpl.addActivityApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivityApp(Long activityAppId) {
        try {
            return DubboResult.successResult((Object)this.activityAppService.deleteActivityApp(activityAppId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityAppBackendServiceImpl.removeActivityApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityAppDto>> searchActivityApp(ReqActivityApp reqActivityApp) {
        try {
            return DubboResult.successResult(this.activityAppService.searchActivityApp(reqActivityApp));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityAppBackendServiceImpl.removeActivityApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

