/**
 * Project Name:media-biz<br>
 * File Name:AccountBackendBO.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo<br>
 * Date:2016年9月30日下午3:43:55<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.bo;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAuditData;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;

/**
 * ClassName: AccountBackendBO <br/>
 * date: 2016年9月30日 下午3:43:55 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface AccountBackendBO {

    /**
     * 媒体账户登录.
     *
     * @param email the email
     * @param password the password
     * @return the result< login rsp>
     * @throws TuiaMediaException the tuia media exception
     */
    Long login(String email, String password) throws TuiaMediaException;

    /**
     * 媒体账户注册.
     *
     * @param req the req
     * @return the register rsp
     * @throws TuiaMediaException the tuia media exception
     */
    RegisterRsp register(ReqRegister req) throws TuiaMediaException;

    /**
     * 获取媒体用户信息.
     *
     * @param mediaId the media id
     * @return the account info
     * @throws TuiaMediaException the tuia media exception
     */
    AccountInfoRsp getAccountInfo(Long mediaId) throws TuiaMediaException;

    /**
     * 重新提交媒体账户审核信息.
     *
     * @param accountInfo the account info
     * @return true, if update audit data
     * @throws TuiaMediaException the tuia media exception
     */
    boolean updateAuditData(ReqUpdateAuditData accountInfo) throws TuiaMediaException;

    /**
     * 账号审核.
     *
     * @param mediaId the media id
     * @param checkType 账号审核状态
     * @param reason the reason
     * @throws TuiaMediaException the media manager exception
     */
    boolean updateCheckStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException;

    /**
     * 账号冻结.
     *
     * @param mediaId the media id
     * @param checkType the check type
     * @param reason the reason
     * @throws TuiaMediaException the media manager exception
     */
    boolean updateFreezeStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException;

    /**
     * 获取审核未通过的账户信息.
     *
     * @param email the email
     * @return the uncheck account info
     * @throws TuiaMediaException the tuia media exception
     */
    AccountInfoRsp getUncheckAccountInfo(String email) throws TuiaMediaException;
}
