/**
 * Project Name:media-biz<br>
 * File Name:ActivityStatisticsDayBO.java<br>
 * Package Name:cn.com.duiba.tuia.media.bo<br>
 * Date:2016年10月18日下午3:30:39<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.bo;

import java.util.List;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityDetailData;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: ActivityStatisticsDayBO <br/>
 * Function: 活动数据. <br/>
 * date: 2016年10月18日 下午3:30:39 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface ActivityStatisticsDayBO {

    /**
     * 分页查询活动统计数据.
     *
     * @param req the req
     * @return the media data
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspGetActivityData> getActivityDataByPage(ReqGetActivityData req) throws TuiaMediaException;

    /**
     * 分页查询活动明细数据.
     *
     * @param req the req
     * @return the media data
     * @throws TuiaMediaException the tuia media exception
     */
    PageResultDto<RspGetActivityDetailData> getActivityDetailDataByPage(ReqGetActivityData req)
                                                                                               throws TuiaMediaException;

    /**
     * 查询活动统计数据列表.
     *
     * @param req the req
     * @return the media data
     * @throws TuiaMediaException the tuia media exception
     */
    List<RspGetActivityData> getActivityDataList(ReqGetActivityData req) throws TuiaMediaException;

    /**
     * 查询活动明细数据列表.
     *
     * @param req the req
     * @return the media data
     * @throws TuiaMediaException the tuia media exception
     */
    List<RspGetActivityDetailData> getActivityDetailDataList(ReqGetActivityData req) throws TuiaMediaException;
}
